% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_functions.R
\name{summarizeQueryRegions}
\alias{summarizeQueryRegions}
\title{summarizeQueryRegions}
\usage{
summarizeQueryRegions(queryRegions, txdbFeatures)
}
\arguments{
\item{queryRegions}{GRanges object imported from a BED file using
\code{importBed} function}

\item{txdbFeatures}{List of GRanges objects - outputs of
\code{getTxdbFeaturesFromGRanges} and \code{getTxdbFeatures} functions}
}
\value{
A data frame with two columns where first column holds features and
  second column holds corresponding counts
}
\description{
This function counts number of query regions that overlap with different
types of gene features.
}
\examples{
data(gff)
data(queryRegions)
txdbFeatures <- getTxdbFeaturesFromGRanges(gffData = gff)
summary <- summarizeQueryRegions(queryRegions = queryRegions,
                                 txdbFeatures = txdbFeatures)

}
