% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_analysis_functions.R
\name{getIntervalOverlapMatrix}
\alias{getIntervalOverlapMatrix}
\title{getIntervalOverlapMatrix}
\usage{
getIntervalOverlapMatrix(
  queryRegionsList,
  targetRegions,
  targetRegionNames = NULL,
  nodeN = 1
)
}
\arguments{
\item{queryRegionsList}{A GRangesList object}

\item{targetRegions}{A GRanges object}

\item{targetRegionNames}{Optional vector of names to be used as rownames in
the resulting matrix. The vector indices must correspond to the intervals
in targetRegions object.}

\item{nodeN}{Positive integer value to use one or more cpus for parallel
computation (default: 1)}
}
\value{
A binary matrix object consisting of number of rows equal to the
  number of intervals in targetRegions object, and number of columns equal to
  the number of GRanges objects available in the queryRegionsList object.
}
\description{
This function is used to obtain a binary matrix of overlaps between a list of
GRanges objects (GRangesList object) and a target GRanges object. The
resulting matrix has N rows where N is the number of intervals in the target
GRanges object and M columns where M is the number GRanges objects in the
query GRangesList object.
}
\examples{
data(gff)
input1 <- system.file("extdata", "testfile.bed", package='RCAS') 
input2 <- system.file("extdata", "testfile2.bed", package='RCAS') 
bedData <- RCAS::importBedFiles(filePaths = c(input1, input2)) 
M <- RCAS::getIntervalOverlapMatrix(
queryRegionsList = bedData, 
targetRegions = gff[gff$type == 'gene',][1:100], 
targetRegionNames = gff[gff$type == 'gene',][1:100]$gene_name)
}
