% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_analysis_functions.R
\name{getFeatureBoundaryCoverageMulti}
\alias{getFeatureBoundaryCoverageMulti}
\title{getFeatureBoundaryCoverageMulti}
\usage{
getFeatureBoundaryCoverageMulti(bedData, txdbFeatures, sampleN = 10000)
}
\arguments{
\item{bedData}{GRangesList object imported from multiple BED files 
using \code{importBedFiles} function}

\item{txdbFeatures}{List of GRanges objects - outputs of 
\code{getTxdbFeaturesFromGRanges} and \code{getTxdbFeatures} functions}

\item{sampleN}{(default=10000) Positive integer value that is used to 
randomly down-sample the target feature coordinates to improve the runtime.
Set to 0 to avoid downsampling.}
}
\value{
A data.frame object with coverage data at three prime and five prime
  boundaries of a list of transcript features
}
\description{
This function is a wrapper function to run RCAS::getFeatureBoundaryCoverage 
multiple times, which is useful to get coverage signals across different 
kinds of transcript features for a given list of bed files imported as a 
GRangesList object.
}
\examples{
data(gff)
data(queryRegions)
queryRegionsList <- GenomicRanges::GRangesList(queryRegions, queryRegions)
names(queryRegionsList) <- c('q1', 'q2')
txdbFeatures <- getTxdbFeaturesFromGRanges(gffData = gff)
getFeatureBoundaryCoverageMulti(queryRegionsList, txdbFeatures, sampleN = 500)

}
