% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_functions.R
\name{calculateCoverageProfileList}
\alias{calculateCoverageProfileList}
\title{calculateCoverageProfileList}
\usage{
calculateCoverageProfileList(
  queryRegions,
  targetRegionsList,
  sampleN = 0,
  bin.num = 100,
  bin.op = "mean",
  strand.aware = TRUE
)
}
\arguments{
\item{queryRegions}{GRanges object imported from a BED file using 
\code{importBed} function}

\item{targetRegionsList}{A list of GRanges objects containing genomic 
coordinates of target features (e.g. transcripts, exons, introns)}

\item{sampleN}{If set to a positive integer, \code{targetRegions} will be 
downsampled to \code{sampleN} regions}

\item{bin.num}{Positive integer value (default: 100) to determine how many
bins the targetRegions should be split into (See
genomation::ScoreMatrixBin)}

\item{bin.op}{The operation to apply for each bin: 'min', 'max', or 'mean'
(default: mean). (See genomation::ScoreMatrixBin)}

\item{strand.aware}{TRUE/FALSE (default: TRUE) The strands of target regions
are considered.}
}
\value{
A data.frame consisting of four columns: 1. bins level 2.
  meanCoverage 3. standardError 4. feature Target regions are divided into
  100 equal sized bins and coverage level is summarized in a strand-specific
  manner using the \code{genomation::ScoreMatrixBin} function. For each bin,
  mean coverage score and the standard error of the mean coverage score is
  calculated (\code{plotrix::std.error})
}
\description{
This function checks overlaps between input query regions and a target list 
of annotation features, and then calculates the coverage profile along the 
target regions.
}
\examples{
data(gff)
data(queryRegions)
txdbFeatures <- getTxdbFeaturesFromGRanges(gffData = gff)
dfList <- calculateCoverageProfileList(queryRegions = queryRegions,
                              targetRegionsList = txdbFeatures,
                                    sampleN = 1000)
}
