% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.image.R
\name{write.image}
\alias{write.image}
\title{Write Images}
\usage{
write.image(x, file, force = FALSE, pixelType, littleEndian)
}
\arguments{
\item{x}{an \code{Image} or \code{\link{AnnotatedImage}} object}

\item{file}{character, file name}

\item{force}{logical(1), if \code{TRUE} overwrite existing file}

\item{pixelType}{character(1), data type to store pixel values}

\item{littleEndian}{boolean(1), pixel data endianness}
}
\value{
File path to \code{file} is returned invisibly.
}
\description{
Save image files using the Bio-Formats library. A list of supported formats can be found on the \href{http://www.openmicroscopy.org/site/support/bio-formats5/supported-formats.html}{Bio-Formats website}.
}
\examples{
f = mockFile(sizeX = 256, sizeY = 256)
img = read.image(f)

tempfile = tempfile("", , ".png")
write.image(img, tempfile)
}
\seealso{
\code{\link{read.image}} for reading images.
}
\author{
Andrzej Oleś <\email{andrzej.oles@gmail.com}>, 2014-2023
}
