% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.metadata.R
\name{read.metadata}
\alias{read.metadata}
\title{Read Image Metadata}
\usage{
read.metadata(file, filter.metadata = FALSE, proprietary.metadata = TRUE)
}
\arguments{
\item{file}{character, file name}

\item{filter.metadata}{logical, specifies whether ugly metadata (entries with unprintable characters, and extremely large entries) should be discarded from the metadata table}

\item{proprietary.metadata}{logical, should proprietary metadata be populated to OME-XML}
}
\value{
An \linkS4class{ImageMetadata} or \linkS4class{ImageMetadataList} object.
}
\description{
Read image metadata using the Bio-Formats library. The list of supported file formats can be found on the \href{http://www.openmicroscopy.org/site/support/bio-formats5/supported-formats.html}{Bio-Formats website}.
}
\examples{
require(EBImage)
f = system.file("images", "nuclei.tif", package="EBImage")

metadata = read.metadata(f)
str(metadata)
}
\seealso{
\code{\link{read.omexml}} for reading image metadata as OME-XML, \code{\link{read.image}} for reading image data
}
\author{
Andrzej Oleś <\email{andrzej.oles@gmail.com}>, 2014-2023
}
