% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afs.R
\name{afs}
\alias{afs}
\title{afs function - Calculates proportion of variants per rare MAC bins}
\usage{
afs(alpha = NULL, beta = NULL, b = NULL, mac_bins, pop = NULL)
}
\arguments{
\item{alpha}{AFS function parameter alpha, does not need to be specified if default parameters are used}

\item{beta}{AFS function parameter beta, does not need to be specified if default parameters are used}

\item{b}{AFS function parameter b, does not need to be specified if default parameters are used}

\item{mac_bins}{The rare MAC bins to use, with Lower and Upper boundaries defined}

\item{pop}{The population: AFR, EAS, NFE or SAS - specified when using default parameters}
}
\value{
data frame with the MAC bins provided and proportion of variants in each bin
}
\description{
The afs function calculates the proportion of variants in minor allele count (MAC) bins given parameters, as described in RAREsim.
}
\details{
The default parameters will be used if an ancestrial population is specified: pop = 'AFR', 'EAS', 'NFE', or 'SAS'.
Otherwise, the parameters alpha, beta, and b need to be provided.
Alpha, beta, and b can be estimated from target data using the *Fit_afs* function.
The MAC bins should be exhaustive, non-overlapping bins of rare allele counts with column names Lower and Upper.
}
\examples{
 data('afs_afr')
 mac <- afs_afr[,c(1:2)]
 afs(mac_bins = mac, pop = 'AFR')
 afs(alpha = 1.594622, beta =  -0.2846474, b  = 0.297495, mac_bins = mac)

}
