% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthetic_internal.R
\encoding{UTF-8}
\name{validateSyntheticGeno}
\alias{validateSyntheticGeno}
\title{Validate input parameters for syntheticGeno() function}
\usage{
validateSyntheticGeno(
  gdsReference,
  gdsRefAnnot,
  fileProfileGDS,
  profileID,
  listSampleRef,
  nbSim,
  prefix,
  pRecomb,
  minProb,
  seqError
)
}
\arguments{
\item{gdsReference}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), the 1KG GDS file.}

\item{gdsRefAnnot}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), the1 1KG SNV Annotation GDS file.}

\item{fileProfileGDS}{a \code{character} string representing the file name of
the GDS Sample file containing the information about the sample.
The file must exist.}

\item{profileID}{a \code{character} string representing the unique
identifier of the cancer sample.}

\item{listSampleRef}{a \code{vector} of \code{character} strings
representing the sample identifiers of the 1KG selected reference samples.}

\item{nbSim}{a single positive \code{integer} representing the number of
simulations that will be generated per sample + 1KG reference combination.}

\item{prefix}{a \code{character} string that represent the prefix that will
be added to the name of the synthetic profiles generated by the function.}

\item{pRecomb}{a single positive \code{numeric} between 0 and 1 that
represents the frequency of phase switching in the synthetic profiles.}

\item{minProb}{a single positive \code{numeric} between 0 and 1 that
represents the probability that the genotype is correct.}

\item{seqError}{a single positive \code{numeric} between 0 and 1
representing the sequencing error rate.}
}
\value{
The integer \code{0L} when the function is successful.
}
\description{
This function validates the input parameters for the
\code{\link[=syntheticGeno]{syntheticGeno()}} function.
}
\examples{

## Directory where demo GDS files are located
dataDir <- system.file("extdata", package="RAIDS")

## The 1KG GDS file (opened)
gdsRef <- openfn.gds(file.path(dataDir,
                "PopulationReferenceDemo.gds"), readonly=TRUE)

## The 1KG GDS Annotation file (opened)
gdsRefAnnot <- openfn.gds(file.path(dataDir,
    "PopulationReferenceSNVAnnotationDemo.gds"), readonly=TRUE)

## The GDS Sample file
gdsSample <- file.path(dataDir, "GDS_Sample_with_study_demo.gds")

## The validation should be successful
RAIDS:::validateSyntheticGeno(gdsReference=gdsRef, gdsRefAnnot=gdsRefAnnot,
     fileProfileGDS=gdsSample, profileID="A101TCGA",
     listSampleRef="A101TCGA", nbSim=1L, prefix="TCGA", pRecomb=0.02,
     minProb=0.999, seqError=0.002)

## All GDS file must be closed
closefn.gds(gdsfile=gdsRef)
closefn.gds(gdsfile=gdsRefAnnot)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
