% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools_internal.R
\encoding{UTF-8}
\name{readSNVBAM}
\alias{readSNVBAM}
\title{Read a VCF file with the genotypes use for the ancestry call}
\usage{
readSNVBAM(
  fileName,
  varSelected,
  offset = 0L,
  paramSNVBAM = list(ScanBamParam = NULL, PileupParam = NULL, yieldSize = 1e+07),
  verbose = FALSE
)
}
\arguments{
\item{fileName}{a \code{character} string representing the name, including
the path, of a BAM file with the index file in the same directory}

\item{varSelected}{a \code{data.frame} representing the position to keep}

\item{offset}{a \code{integer} representing the offset to be added to the
position of the SNVs. The value of offset
is added to the position present in the file. Default: \code{0L}.}

\item{paramSNVBAM}{a \code{list} containing the parameters passed to the
BamFile() function. Default: \code{list(ScanBamParam=NULL, PileupParam=NULL, 
yieldSize=10000000)}.}

\item{verbose}{a \code{logical} indicating if messages should be printed
to show how the different steps in the function. Default: \code{FALSE}.}
}
\value{
a \code{data.frame} containing at least:
\describe{
\item{Chromosome}{ a \code{numeric} representing the name of
the chromosome}
\item{Position}{ a \code{numeric} representing the position on the
chromosome}
\item{Ref}{ a \code{character} string representing the reference nucleotide}
\item{Alt}{ a \code{character} string representing the alternative
nucleotide}
\item{File1R}{ a \code{numeric} representing the count for
the reference nucleotide}
\item{File1A}{ a \code{numeric} representing the count for the
alternative nucleotide}
\item{count}{ a \code{numeric} representing the total count}
}
}
\description{
The function reads VCF file and
returns a data frame
containing the information about the read counts for the SNVs present in
the file.
}
\examples{


## Required library for this example to run correctly
if (requireNamespace("Rsamtools", quietly=TRUE)) {
    ## Demo bam
    fl <- system.file("extdata", "no_which_buffered_pileup.bam", 
            package="Rsamtools", mustWork=TRUE)
          
    RAIDS:::readSNVBAM(fl, varSelected=data.frame(chr=c(1,1), 
                start=c(3,5), REF=c("A", "A"), ALT=c("C", "C")))
}

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
