% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthetic_internal.R
\encoding{UTF-8}
\name{prepPedSynthetic1KG}
\alias{prepPedSynthetic1KG}
\title{Extract the sample information from the 1KG GDS file for a list
of profiles associated to a specific study in the Profile GDS file}
\usage{
prepPedSynthetic1KG(gdsReference, gdsSample, studyID, popName)
}
\arguments{
\item{gdsReference}{an object of class
\code{\link[gdsfmt:gds.class]{gdsfmt::gds.class}}, the opened 1 KG GDS file.}

\item{gdsSample}{an object of class
\code{\link[gdsfmt:gds.class]{gdsfmt::gds.class}}, the opened Profile GDS
file.}

\item{studyID}{a \code{character} string representing the name of the
study that will be extracted from the GDS Sample 'study.annot' node.}

\item{popName}{a \code{character} string representing the name of the
column from the \code{data.frame} stored in the 'sample.annot' node of the
1KG GDS file. The column must be present in the \code{data.frame}.}
}
\value{
\code{data.frame} containing the columns extracted from the
GDS Sample 'study.annot' node with a extra column named as the 'popName'
parameter that has been extracted from the 1KG GDS 'sample.annot' node.
Only the rows corresponding to the specified study ('studyID' parameter)
are returned.
}
\description{
The function extracts the information for the profiles
associated to a specific study in the GDS Sample file. The information is
extracted from the 'study.annot' node as a 'data.frame'.

Then, the function used the 1KG GDS file to extract specific information
about each sample and add it, as an extra column, to the 'data.frame'.

As example, this function can extract the synthetic profiles
for a GDS Sample and the super-population of the 1KG samples used to
generate each synthetic profile would be added
as an extra column to the final 'data.frame'.
}
\details{
As example, this function can extract the synthetic profiles
for a Profile GDS and the super-population of the 1KG samples used to
generate each synthetic profile would be added
as an extra column to the final 'data.frame'. In that situation, the
'popName' parameter would correspond to the super-population column and the
'studyID' parameter would be the name given to the synthetic dataset.
}
\examples{

## Required library
library(gdsfmt)

## The open 1KG GDS file is required (this is a demo file)
dataDir <- system.file("extdata", package="RAIDS")
gds_1KG_file <- file.path(dataDir, "PopulationReferenceDemo.gds")
gds1KG <- openfn.gds(gds_1KG_file)

fileSampleGDS <- file.path(dataDir, "GDS_Sample_with_study_demo.gds")
gdsSample <- openfn.gds(fileSampleGDS)

## Extract the study information for "TCGA.Synthetic" study present in the
## Profile GDS file and merge column "superPop" from 1KG GDS to the
## returned data.frame
## This function enables to extract the super-population associated to the
## 1KG samples that has been used to create the synthetic profiles
RAIDS:::prepPedSynthetic1KG(gdsReference=gds1KG, gdsSample=gdsSample,
    studyID="TCGA.Synthetic", popName="superPop")

## The GDS files must be closed
gdsfmt::closefn.gds(gds1KG)
gdsfmt::closefn.gds(gdsSample)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
