% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RAIDS.R
\docType{data}
\name{matKNNSynthetic}
\alias{matKNNSynthetic}
\title{A small \code{data.frame} containing the
inferred ancestry on the synthetic profiles.}
\format{
The \code{data.frame} containing the information about the
synthetic profiles. The \code{data.frame} contains 4 columns:
\describe{
\item{\code{sample.id}}{ a \code{character} string representing the unique
synthetic profile identifier.}
\item{\code{D}}{ a \code{numeric} representing the number of dimensions used
to infer the ancestry of the synthetic profile.}
\item{\code{K}}{ a \code{numeric} representing the number of neighbors used
to infer the ancestry of the synthetic profile.}
\item{\code{SuperPop}}{ a \code{character} string representing the
inferred ancestry of the synthetic profile for the specific D and K values.}
}
}
\usage{
data(matKNNSynthetic)
}
\value{
The \code{data.frame} containing the information about the
synthetic profiles. The \code{data.frame} contains 4 columns:
\describe{
\item{\code{sample.id}}{ a \code{character} string representing the unique
synthetic profile identifier.}
\item{\code{D}}{ a \code{numeric} representing the number of dimensions used
to infer the ancestry of the synthetic profile.}
\item{\code{K}}{ a \code{numeric} representing the number of neighbors used
to infer the ancestry of the synthetic profile.}
\item{\code{SuperPop}}{ a \code{character} string representing the
inferred ancestry of the synthetic profile for the specific D and K values.}
}
}
\description{
The object is a \code{data.frame} with 4 columns.
}
\details{
This dataset can be
used to test the \code{\link{computeSyntheticROC}} function.
}
\examples{

## Loading demo dataset containing pedigree information for synthetic
## profiles
data(pedSynthetic)

## Loading demo dataset containing the inferred ancestry results
## for the synthetic data
data(matKNNSynthetic)

## Retain one K and one D value
matKNN <- matKNNSynthetic[matKNNSynthetic$D == 5 & matKNNSynthetic$K == 4, ]

## Compile statistics from the
## synthetic profiles for fixed values of D and K
results <- RAIDS:::computeSyntheticROC(matKNN=matKNN,
    matKNNAncestryColumn="SuperPop",
    pedCall=pedSynthetic, pedCallAncestryColumn="superPop",
    listCall=c("EAS", "EUR", "AFR", "AMR", "SAS"))

results$matAUROC.All
results$matAUROC.Call
results$listROC.Call


}
\seealso{
\describe{
\item{\code{\link{computeSyntheticROC}}}{ for calculating the AUROC of
the inferences for specific values of D and K using the inferred
ancestry results from the synthetic profiles}
}
}
\keyword{datasets}
