% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process1KG.R
\encoding{UTF-8}
\name{getRef1KGPop}
\alias{getRef1KGPop}
\title{Extract the specified column from the 1KG GDS 'sample.ref' node
for the reference profiles (real ancestry assignation)}
\usage{
getRef1KGPop(gdsReference, popName = "superPop")
}
\arguments{
\item{gdsReference}{an object of class
\link[gdsfmt]{gds.class} (a GDS file), the opened Reference GDS file.}

\item{popName}{a \code{character} string representing the name of the column
that will be fetched in the \code{data.frame} present in the Reference GDS
"sample.ref" node. The column must be present in the \code{data.frame}.
Default: \code{"superPop"}.}
}
\value{
\code{vector} of \code{character} strings representing the content
of the extracted column for the 1KG GDS 'sample.ref' node. The values
represent the known ancestry assignation. The profile
identifiers are used as names for the \code{vector}.
}
\description{
The function extract the specified column for the 'sample.ref'
node present in the Reference GDS file. The column must be present in the
\code{data.frame} saved in the 'sample.ref' node. Only the information for
the reference profiles is returned. The values
represent the known ancestry assignation.
}
\examples{

## Required library
library(gdsfmt)

## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

## Open existing demo 1K GDS file with "sample.ref" node
nameFileGDS <- file.path(dataDir, "PopulationReferenceDemo.gds")
fileGDS <- snpgdsOpen(nameFileGDS)

## Extract super population information for the 1KG profiles
getRef1KGPop(gdsReference=fileGDS, popName="superPop")

## Close 1K GDS file
closefn.gds(fileGDS)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
