% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process1KG.R
\encoding{UTF-8}
\name{generateGDS1KG}
\alias{generateGDS1KG}
\title{Generate the GDS file that will contain the information from
Reference data set (reference data set)}
\usage{
generateGDS1KG(
  pathGeno = file.path("data", "sampleGeno"),
  filePedRDS,
  fileSNVIndex,
  fileSNVSelected,
  fileNameGDS,
  listSamples = NULL,
  verbose = FALSE
)
}
\arguments{
\item{pathGeno}{a \code{character} string representing the path where
the 1K genotyping files for each sample are located. The name of the
genotyping files must correspond to
the individual identification (Individual.ID) in the pedigree file.
Default: \code{"./data/sampleGeno"}.}

\item{filePedRDS}{a \code{character} string representing the path and file
name of the RDS file that contains the pedigree information. The file must
exist. The file must be a RDS file.}

\item{fileSNVIndex}{a \code{character} string representing the path and file
name of the RDS file that contains the indexes of the retained SNPs. The
file must exist. The file must be a RDS file.}

\item{fileSNVSelected}{a \code{character} string representing the path and
file name of the RDS file that contains the filtered SNP information. The
file must exist. The file must be a RDS file.}

\item{fileNameGDS}{a \code{character} string representing the path and file
name of the GDS file that will be created. The GDS file will contain the
SNP information, the genotyping information and the pedigree information
from 1000 Genomes.
The extension of the file must be '.gds'.}

\item{listSamples}{a \code{vector} of \code{character} string corresponding
to samples (must be the sample.ids) that will be retained and added to the
GDS file. When \code{NULL}, all the samples are retained.
Default: \code{NULL}.}

\item{verbose}{a \code{logical} indicating if the funciton must print
messages when running. Default: \code{FALSE}.}
}
\value{
The integer \code{0L} when successful.
}
\description{
This function generates the GDS file that will contain the
information from Reference. The function also add the samples information,
the SNP information and the genotyping information into the GDS file.
}
\details{
More information about GDS file format can be found at the Bioconductor
gdsfmt website:
https://bioconductor.org/packages/gdsfmt/
}
\examples{

## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

## Path to the CSV genoytype files
pathGeno <- file.path(dataDir, "demoProfileGenotypes")

## The RDS file containing the pedigree information
pedigreeFile <- file.path(dataDir, "PedigreeReferenceDemo.rds")

## The RDS file containing the indexes of the retained SNPs
snpIndexFile <- file.path(dataDir, "listSNPIndexes_Demo.rds")

## The RDS file containing the filtered SNP information
filterSNVFile <- file.path(dataDir, "mapSNVSelected_Demo.rds")

## Temporary Reference GDS file
tempRefGDS <- file.path(tempdir(), "1KG_TEMP.gds")

## Create a temporary Reference GDS file
generateGDS1KG(pathGeno=pathGeno, filePedRDS=pedigreeFile,
            fileSNVIndex=snpIndexFile, fileSNVSelected=filterSNVFile,
            fileNameGDS=tempRefGDS, listSamples=NULL)

## Remove temporary files
unlink(tempRefGDS, force=TRUE)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
