% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper_internal.R
\encoding{UTF-8}
\name{appendGDSRefSample}
\alias{appendGDSRefSample}
\title{Append fields related to samples into a GDS file}
\usage{
appendGDSRefSample(
  gdsReference,
  dfPedReference,
  batch = 1,
  listSamples = NULL,
  verbose = TRUE
)
}
\arguments{
\item{gdsReference}{an object of class
\link[gdsfmt]{gds.class} (a GDS file), the opened GDS file.}

\item{dfPedReference}{a \code{data.frame} with the information about
the sample(s).
The \code{data.frame} must have the columns: "sample.id", "Name.ID", "sex",
"pop.group" and "superPop". The unique identifier for the sample(s) is
the "Name.ID" column and the row names of the \code{data.frame} must
correspond to the "Name.ID" column.}

\item{batch}{a \code{integer} representing the batch identifier.}

\item{listSamples}{a \code{vector} of \code{character} string with the
selected sample(s). If \code{NULL}, all samples are used.}

\item{verbose}{a \code{logical} indicating if messages should be printed
to show how the different steps in the function. Default: \code{TRUE}.}
}
\value{
The integer \code{0L} when successful.
}
\description{
This function appends the fields related to samples into
a GDS file. The information is extracted from the \code{data.frame} passed
to the function and is added to the "sample.annot" and "sample.id" nodes.
The "sample.id" and "sample.annot" nodes must already exist.
If the samples are part of a study, the function
addStudyGDSSample() must be used.
}
\examples{

## Required library
library(gdsfmt)

## Create a temporary GDS file in an test directory
gdsFilePath <- file.path(tempdir(), "GDS_TEMP_03.gds")

## Create and open the GDS file
tmpGDS <- createfn.gds(filename=gdsFilePath)

## Create "sample.id" node (the node must be present)
add.gdsn(node=tmpGDS, name="sample.id", val=c("sample_01",
        "sample_02"))

## Create "sample.annot" node (the node must be present)
add.gdsn(node=tmpGDS, name="sample.annot", val=data.frame(
            Name.ID=c("sample_01", "sample_02"),
            sex=c(1,1),  # 1:Male  2: Female
            pop.group=c("ACB", "ACB"),
            superPop=c("AFR", "AFR"),
            batch=c(1, 1),
            stringsAsFactors=FALSE))

sync.gds(gdsfile=tmpGDS)

## Create a data.frame with information about samples
sample_info <- data.frame(Name.ID=c("sample_04", "sample_05",
                                "sample_06"),
                        sex=c(1,2,1),  # 1:Male  2: Female
                        pop.group=c("ACB", "ACB", "ACB"),
                        superPop=c("AFR", "AFR", "AFR"),
                        stringsAsFactors=FALSE)

## The row names must be the sample identifiers
rownames(sample_info) <- sample_info$Name.ID

## Add information about 2 samples to the GDS file
RAIDS:::appendGDSRefSample(gdsReference=tmpGDS,
        dfPedReference=sample_info,
        batch=2, listSamples=c("sample_04", "sample_06"), verbose=FALSE)

## Read sample identifier list
## Only "sample_04" and "sample_06" should have been added
read.gdsn(index.gdsn(node=tmpGDS, path="sample.id"))

## Read sample information from GDS file
## Only "sample_04" and "sample_06" should have been added
read.gdsn(index.gdsn(node=tmpGDS, path="sample.annot"))

## Close GDS file
closefn.gds(gdsfile=tmpGDS)

## Delete the temporary GDS file
unlink(x=gdsFilePath, force=TRUE)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
