% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper_internal.R
\encoding{UTF-8}
\name{addUpdateLap}
\alias{addUpdateLap}
\title{Add information related to low allelic fraction associated to
the SNV dataset for a specific sample into a GDS file}
\usage{
addUpdateLap(gdsProfile, snpLap)
}
\arguments{
\item{gdsProfile}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), a GDS file.}

\item{snpLap}{a \code{vector} of \code{numeric} value representing the
low allelic fraction for each SNV present in the SNV dataset. The
values should be between \code{0} and \code{0.50}. The
length of the \code{vector} should correspond to the number of SNVs
present in the "snp.id" entry of the GDS sample file.}
}
\value{
The integer \code{0L} when successful.
}
\description{
The function adds the information related to low allelic
fraction
associated to the SNV dataset for a specific sample into a
GDS file, more specifically, in the "lap" node. The "lap" node must
already be present in the GDS file.
}
\examples{

## Required library
library(gdsfmt)

## Create a temporary GDS file
gdsFilePath <- file.path(tempdir(), "GDS_TEMP.gds")

## Create and open the GDS file
gdsFile  <- createfn.gds(filename=gdsFilePath)

## Create a "lap" node
add.gdsn(node=gdsFile, name="lap", val=rep(10L, 12))
sync.gds(gdsFile)

## Vector of low allelic fraction
lap <- c(0.1, 0.23, 0.34, 0.00, 0.12, 0.11, 0.33, 0.55)

## Add segments to the GDS file
RAIDS:::addUpdateLap(gdsProfile=gdsFile, snpLap=lap)

## Read lap information from GDS file
read.gdsn(index.gdsn(node=gdsFile, path="lap"))

## Close GDS file
closefn.gds(gdsfile=gdsFile)

## Delete the temporary GDS file
unlink(x=gdsFilePath, force=TRUE)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
