% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process1KG.R
\encoding{UTF-8}
\name{addGeneBlockGDSRefAnnot}
\alias{addGeneBlockGDSRefAnnot}
\title{Append information associated to blocks, as indexes, into the
Population Reference SNV Annotation GDS file}
\usage{
addGeneBlockGDSRefAnnot(
  gdsReference,
  gdsRefAnnotFile,
  winSize = 10000,
  ensDb,
  suffixBlockName
)
}
\arguments{
\item{gdsReference}{an object of class
\link[gdsfmt]{gds.class} (a GDS file), the opened Reference GDS file.}

\item{gdsRefAnnotFile}{a \code{character} string representing the
file name corresponding the Reference SNV
Annotation GDS file. The function will
open it in write mode and close it after. The file must exist.}

\item{winSize}{a single positive \code{integer} representing the
size of the window to use to group the SNVs when the SNVs are in a
non-coding region. Default: \code{10000L}.}

\item{ensDb}{An object with the ensembl genome annotation
Default: \code{EnsDb.Hsapiens.v86}.}

\item{suffixBlockName}{a \code{character} string that identify the source
of the block and that will be added to the block description into
the Reference SNV Annotation GDS file, as example: Ensembl.Hsapiens.v86.}
}
\value{
The integer \code{OL} when the function is successful.
}
\description{
The function appends the information about the blocks into
the Population Reference SNV Annotation GDS file. The information is
extracted from the Population Reference GDS file.
}
\examples{

## Required library
library(SNPRelate)

## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

fileAnnotGDS <- file.path(tempdir(), "ex1_good_small_1KG_Ann_GDS.gds")

## Required library
if (requireNamespace("EnsDb.Hsapiens.v86", quietly=TRUE)) {

    file.copy(file.path(dataDir, "tests",
        "ex1_NoBlockGene.1KG_Annot_GDS.gds"), fileAnnotGDS)

    ## Making a "short cut" on the ensDb object
    edb <- EnsDb.Hsapiens.v86::EnsDb.Hsapiens.v86

    ## GDS Reference file
    fileReferenceGDS  <- file.path(dataDir, "tests",
                "ex1_good_small_1KG.gds")

    \donttest{
        ## Open the reference GDS file (demo version)
        gds1KG <- snpgdsOpen(fileReferenceGDS)

        ## Append information associated to blocks
        addGeneBlockGDSRefAnnot(gdsReference=gds1KG,
            gdsRefAnnotFile=fileAnnotGDS,
            ensDb=edb,
            suffixBlockName="EnsDb.Hsapiens.v86")

        gdsAnnot1KG <- openfn.gds(fileAnnotGDS)
        print(gdsAnnot1KG)
        print(read.gdsn(index.gdsn(gdsAnnot1KG, "block.annot")))

       ## Close GDS files
       closefn.gds(gds1KG)
       closefn.gds(gdsAnnot1KG)
    }

    ## Remove temporary file
    unlink(fileAnnotGDS, force=TRUE)

}

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
