% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process1KG.R
\encoding{UTF-8}
\name{addBlockFromDetFile}
\alias{addBlockFromDetFile}
\title{Append information associated to ld blocks, as indexes, into the
Population Reference SNV Annotation GDS file}
\usage{
addBlockFromDetFile(
  fileReferenceGDS,
  gdsRefAnnotFile,
  pathBlock,
  superPop,
  blockName = "ldBlock",
  blockDesc = "Not Define",
  verbose = FALSE
)
}
\arguments{
\item{fileReferenceGDS}{a \code{character} string representing the file
name of the Reference GDS file. The file must exist.}

\item{gdsRefAnnotFile}{a \code{character} string representing the
file name corresponding the Reference SNV
Annotation GDS file. The function will
open it in write mode and close it after. The file must exist.}

\item{pathBlock}{a \code{character} string representing the directory
where all the output file det from the plink block command are located.
The directory must not include other file with the extension \'.det\'.
The name of the \'.det\' must include the super-population between \'.\'
and the chromosome in the form \'chrNumber.\' \( \'chr1.\'\).}

\item{superPop}{a \code{character} string representing the super population.}

\item{blockName}{a \code{character} string representing the id of the block.
The blockName should not exist in \'gdsRefAnnotFile\'.
Default: \code{"ldBlock"}.}

\item{blockDesc}{a \code{character} string representing the description of
the block.
Default: \code{"Not Define"}}

\item{verbose}{a \code{logical} indicating if message information should be
printed. Default: \code{FALSE}.}
}
\value{
\code{OL} when the function is successful.
}
\description{
The function appends the information about the ld blocks into
the Population Reference SNV Annotation GDS file. The information is
extracted from the Population Reference GDS file and files \'.det\'.
}
\details{
More information about GDS file format can be found at the Bioconductor
gdsfmt website:
https://bioconductor.org/packages/gdsfmt/
}
\examples{

## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

fileAnnotGDS <- file.path(tempdir(), "ex1_good_small_1KG_Ann_GDS.gds")

## Demo of of output file det from the plink block
## command for chromosome 1
fileLdBlock <- file.path(dirname(fileAnnotGDS), "block.sp.EUR.Ex.chr1.blocks.det")


file.copy(file.path(dataDir, "tests",
    "ex1_NoBlockGene.1KG_Annot_GDS.gds"), fileAnnotGDS)
file.copy(file.path(dataDir, "block.sp.EUR.Ex.chr1.blocks.det"),
    fileLdBlock)



## GDS Reference file
fileReferenceGDS  <- file.path(dataDir, "tests",
    "ex1_good_small_1KG.gds")

 \donttest{


    ## Append information associated to blocks
    addBlockFromDetFile(fileReferenceGDS=fileReferenceGDS,
        gdsRefAnnotFile=fileAnnotGDS,
        pathBlock=dirname(fileAnnotGDS),
        superPop="EUR")

    gdsAnnot1KG <- openfn.gds(fileAnnotGDS)
    print(gdsAnnot1KG)

    closefn.gds(gdsAnnot1KG)
}

## Remove temporary file
unlink(fileAnnotGDS, force=TRUE)
unlink(fileLdBlock, force=TRUE)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
