\name{coverageOnTarget}

\alias{coverageOnTarget}
\alias{coverageOnTarget,list,GRanges-method}

\title{
Computes the coverage restricted to the target region.
}
\description{
This method computes the approximate coverage of each base in a given region.
}

\usage{
coverageOnTarget(alnReads, targetRegion)
}

\arguments{
  \item{alnReads}{
  A list as returned by \code{scanBam} storing aligned reads.
}
  \item{targetRegion}{
  The target region as a \code{GRanges} object. The chromosome names must
  fit to the chromosome names used in the alignment information of the
  given reads.
}
}

\details{
The detailed alignment information given by the CIGAR strings in .bam
files are ignored by the function. Instead, it is assumed that the whole
read alignes to the reference without indels. This is often not true for
longer read (e.g. generated with Roche 454 Sequencing), but saves
computation time.
}

\value{
A list of the same length as the \code{alnReads} argument. Each list
element is an integer vector of the same length as the target region (in
bases) and stores the coverage generated by the reads from the
corresponding list element of \code{alnReads}.
}

\author{
Hans-Ulrich Klein
}

\seealso{
\code{\link{scanBam}}
}

\examples{
library(Rsamtools)
bamFile = system.file("extdata", "SVDetection", "bam", "N01.bam", package="R453Plus1Toolbox")
bam = scanBam(bamFile)
region = GRanges(IRanges(start=118307205, end=118395936), seqnames=11)
cov = coverageOnTarget(bam, region)
}

\keyword{"coverage"}