% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtle_state_id.R
\docType{methods}
\name{qtle-state-id}
\alias{qtle-state-id}
\alias{state_id}
\alias{state_id<-}
\alias{state_id,QTLExperiment-method}
\alias{state_id<-,QTLExperiment-method}
\title{Modify and view state ID}
\usage{
\S4method{state_id}{QTLExperiment}(object)

\S4method{state_id}{QTLExperiment}(object) <- value
}
\arguments{
\item{object}{is a \linkS4class{QTLExperiment} object}

\item{value}{is a character vector with length equal to the number of columns/states in \code{object}.}
}
\value{
For \code{state_id}, a vector is returned containing the name of the
state tested in each association.
For \code{state_id<-}, a modified \code{object} is returned with the
updated state_ids in \code{\link{colData}}, and
in the row.names of the \linkS4class{QTLExperiment} object.
}
\description{
These are methods for getting or setting protected colData columns (i.e.
state_id).
}
\details{
QTL are associations between a genetic variant and a quantitative state.
The \code{state_id} methods can be used to get or set state IDs for all
tests in a \linkS4class{QTLExperiment} object. The values are
stored in the \code{\link{colData}} as
the \code{\link{state_id}} field so it can be easily accessed but not
accidentally removed or overwritten.
}
\examples{
qtle <- mockQTLE()
state_id(qtle) <- gsub("state", "State_", state_id(qtle))
state_id(qtle)

}
\author{
Christina B Azodi, Amelia Dunstone
}
