% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtle_rowData.R
\docType{methods}
\name{qtle-rowData}
\alias{qtle-rowData}
\alias{rowData}
\alias{rowData<-}
\alias{rowData,QTLExperiment-method}
\alias{rowData<-,QTLExperiment-method}
\alias{rowData<-,QTLExperiment,DataFrame-method}
\alias{rowData<-,QTLExperiment,NULL-method}
\title{rowData method for QTLExperiment}
\usage{
\S4method{rowData}{QTLExperiment}(x, use.names = TRUE)

\S4method{rowData}{QTLExperiment,DataFrame}(x) <- value

\S4method{rowData}{QTLExperiment,NULL}(x) <- value
}
\arguments{
\item{x}{is a \linkS4class{QTLExperiment} object}

\item{use.names}{is a logical specifying whether or not to propagate 
the rownames of \code{x} to the returned DFrame object.}

\item{value}{is a matrix-like object with number of rows equal 
to the number of rows in \code{x}.}
}
\value{
For \code{rowData}, a DFrame is returned. 
For \code{rowData<-}, a modified \linkS4class{QTLExperiment} object is returned with the
updated \code{\link{rowData}}.
}
\description{
Methods for changing the \code{\link{rowData}} of a QTLExperiment.
}
\details{
The \code{feature_id} and \code{variant_id} columns in the \code{rowData} are protected, and operations 
ensure that these columns are preserved in the rowData.
}
\examples{
qtle <- mockQTLE()
rowData(qtle)
dim(rowData(qtle))

rowData(qtle)$chr <- ifelse(feature_id(qtle) \%in\% c("geneA", "geneB"), "chr1", "chr2")
rowData(qtle)

# The state_id column is protected
rowData(qtle) <- NULL
rowData(qtle)

}
\author{
Christina B Azodi, Amelia Dunstone
}
