% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getCompositionPValue}
\alias{getCompositionPValue}
\title{Approximate p-value by Resampling Integer Compositions}
\usage{
getCompositionPValue(t, n, k, p, wList, alternative, type, resamp_number)
}
\arguments{
\item{t}{Value of test statistic \eqn{||S_{n,k}(D)/n||_{p,\boldsymbol{w}}^p}
computed from data \eqn{D}}

\item{n}{Sample size of \eqn{y}}

\item{k}{Sample size of \eqn{x}}

\item{p}{Power exponent of test statistic}

\item{wList}{Weight vector}

\item{alternative}{Character string that should be one of "\code{two.sided}"
(default), "\code{greater}" or "\code{less}"}

\item{type}{If using resampling approximation, either an unbiased estimate
of ("\code{unbiased}", default), or valid, but biased estimate of, ("\code{valid}")
p-value (see Hemerik and Goeman, 2018), or both ("\code{both}").
Default is "\code{unbiased}".}

\item{resamp_number}{Number of compositions of \eqn{n} to draw
(default is 5000)}
}
\value{
p-value (scalar)
}
\description{
Given the value of the test statistic \eqn{t}, the sample sizes \eqn{n} and
\eqn{k},power exponent \eqn{p} and vector of weights that together determine
the test statistic (by default \eqn{n\geqslant k}), as well as the
user-specified resampling number (by default this is \eqn{5000}),
performs resampling from the collection of integer compositions
to approximate the p-value of the observed test statistic.
}
\details{
For \eqn{n} and \eqn{k} small enough (\eqn{n\leqslant 40, k\leqslant 10}),
computes exact p-value by computing the test statistic across all
\eqn{k}-compositions of \eqn{n} under the uniform distribution.

The function returns a two-sided p-value by default, which is more
conservative. Users can choose other p-values corresponding to different
alternatives; see documentation on \code{alternative}. Note that the
interpretation of the choice of \code{alternative} depends on the choice of
weight vector. For example, a weight vector that is a quadratic kernel will
upweight the extreme components of the weight vector. For this choice,
setting \code{alternative} to be \code{greater} translates into an alternative
hypothesis of a bigger spread in the larger sample
(the one with sample size \eqn{n}).

Dependencies: arrangements::compositions
}
\examples{

getCompositionPValue(
    t = 0.5, n = 50, k = 11, p = 1, wList = (10:0) / 10,
    alternative = "two.sided", type = "unbiased", resamp_number = 5000
)

}
