% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QRscore.R
\name{QRscore_ZINB}
\alias{QRscore_ZINB}
\title{Non-Parametric Two-Sample Tests Designed for Testing Differences in Mean or
Dispersion Parameters in (Zero-Inflated) Negative Binomial Distributions.}
\usage{
QRscore_ZINB(
  x,
  y,
  size_factors = NULL,
  zero_inflation = TRUE,
  LR.test = FALSE,
  approx = "resample",
  alternative = "two.sided",
  resamp_num = 20000,
  pi_threshold = 0.95,
  gene.name = NULL,
  measure = "mean",
  p_value = TRUE
)
}
\arguments{
\item{x}{First sample}

\item{y}{Second sample}

\item{size_factors}{Optional vector of size factors for weight estimation.
If provided, log-transformed size factors are used as offsets in
NB/ZINB model fitting.}

\item{zero_inflation}{If TRUE, automatically chooses between ZINB and NB
models based on the data; if FALSE, applies NB model estimation.}

\item{LR.test}{Whether to use a likelihood ratio test to determine which
model (NB or ZINB) to fit}

\item{approx}{Which approximation method to use (default \code{resample})}

\item{alternative}{How p-value should be computed; must be one of
"\code{two.sided}", "\code{greater}" or "\code{less}".}

\item{resamp_num}{Number of \eqn{k}-compositions of \eqn{n} or simplex
vectors in \eqn{[0,1]^k} to draw}

\item{pi_threshold}{Threshold for estimated proportion of zeros in ZINB model}

\item{gene.name}{Optional, name of the gene if applicable, used for
customized messages.}

\item{measure}{Specifies whether to test for shifts in "\code{mean}" or
"\code{dispersion}".}

\item{p_value}{If TRUE, returns a p-value, else returns test statistics and
weights.}
}
\value{
p-value or test statistics depending on \code{p_value} parameter.
}
\description{
This function evaluates the null hypothesis that two samples,
\eqn{\boldsymbol{x}} and \eqn{\boldsymbol{y}}, are drawn from the same
distribution, specifically designed for NB or ZINB models. It is particularly
effective in detecting shifts in either the mean or the dispersion
parameters.
}
\details{
The function automatically computes optimal weights for the chosen model and
derives a p-value based on the selected test statistic and approximation
method.

Additional tuning parameters include: (1) whether to use a likelihood ratio
test to determine which model (NB or ZINB) to fit, (2) the approximation
method (default is resampling, with asymptotic estimation for large
samples),(3) choice of p-value computation (one- or two-sided),
(4) threshold for estimated proportion of zeros in ZINB model
(returns NA if exceeded).

Dependencies: pscl::zeroinfl, MASS::glm.nb, and auxiliary functions from
\code{auxiliary.R}
}
\examples{

set.seed(1)
# Two-sample example comparing mean shifts
QRscore_ZINB(
    x = rzinbinom(100, size = 2, mu = 20, pi = 0),
    y = rzinbinom(100, size = 2, mu = 30, pi = 0),
    zero_inflation = FALSE, LR.test = FALSE, alternative = "greater",
    approx = "asymptotic", measure = "mean"
)

# Two-sample example comparing dispersion shifts
QRscore_ZINB(
    x = rzinbinom(100, size = 2, mu = 20, pi = 0.1),
    y = rzinbinom(100, size = 1, mu = 20, pi = 0.1),
    zero_inflation = TRUE, LR.test = TRUE, alternative = "two.sided",
    approx = "asymptotic", measure = "dispersion"
)

# Two-sample example with significant zero inflation and variance shift
QRscore_ZINB(
    x = rzinbinom(30, size = 4, mu = 20, pi = 0.1),
    y = rzinbinom(30, size = 1, mu = 20, pi = 0.3),
    zero_inflation = TRUE, LR.test = FALSE, alternative = "two.sided",
    approx = "resample", resamp_num = 50000, measure = "dispersion"
)
# Two-sample example with size factors, zero inflation, and dispersion shift
sf_x <- runif(100, 0.5, 1.5)
sf_y <- runif(100, 0.5, 1.5)
QRscore_ZINB(
    x = rzinbinom(100, size = 4, mu = sf_x * 25, pi = 0.1),
    y = rzinbinom(100, size = 1,   mu = sf_y * 25, pi = 0.1),
    size_factors = c(sf_x, sf_y),
    zero_inflation = TRUE, LR.test = TRUE, alternative = "two.sided",
    approx = "resample", resamp_num = 20000, measure = "dispersion"
)
}
