% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/de_analysis.R
\name{QRscoreGenetest}
\alias{QRscoreGenetest}
\title{Perform Differential Expression Analysis using QRscore}
\usage{
QRscoreGenetest(
  expr_matrix,
  labels,
  size_factors = NULL,
  pairwise_test = FALSE,
  pairwise_logFC = FALSE,
  test_mean = TRUE,
  test_dispersion = FALSE,
  num_cores = 1,
  verbose = FALSE,
  rank = TRUE,
  seed = 1,
  ...
)
}
\arguments{
\item{expr_matrix}{A prefiltered raw count matrix (gene \eqn{\times}
sample).}

\item{labels}{A vector of labels corresponding to the samples.}

\item{size_factors}{A vector of size factors estimated from DESeq2}

\item{pairwise_test}{Logical, whether to perform pairwise test statistics
for more than two groups.}

\item{pairwise_logFC}{Logical, whether to calculate pairwise log fold
changes for mean and variance.}

\item{test_mean}{Logical, whether to test the mean.}

\item{test_dispersion}{Logical, whether to test the dispersion.}

\item{num_cores}{Integer, number of cores to use for parallel processing.}

\item{verbose}{Logical, whether to suppress all messages except warnings and
errors.}

\item{rank}{Logical. If TRUE, returns a ranked list of DEGs or DDGs sorted
by p-values.}

\item{seed}{Integer. Set seed in parallel computing.}

\item{...}{Additional arguments passed to the \code{QRscoreTest} function.}
}
\value{
A list with two data frames: \code{mean_test} and \code{var_test}.
}
\description{
This function performs differential expression analysis using the QRscore
method.
}
\examples{
data(example_dataset)
results <- QRscoreGenetest(
  expr_matrix = example_dataset$example_data1,
  labels = example_dataset$labels1,
  size_factors = example_dataset$size_factors1,
  pairwise_test = FALSE, pairwise_logFC = TRUE,
  test_mean = TRUE, test_dispersion = TRUE, num_cores = 2,
  approx = "asymptotic"
)
head(results$var_test)

results2 <- QRscoreGenetest(
  expr_matrix = example_dataset$example_data2,
  labels = example_dataset$labels2,
  size_factors = example_dataset$size_factors2,
  pairwise_test = TRUE, pairwise_logFC = TRUE,
  test_mean = TRUE, test_dispersion = FALSE, num_cores = 2,
  approx = "asymptotic"
)
head(results2$mean_test)
}
