% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QRscore-package.R
\docType{package}
\name{QRscore}
\alias{QRscore}
\alias{QRscore-package}
\title{QRscore: Nonparametric Quantile Rank Score Tests for Distributional Shifts
in Gene Expression}
\description{
The QRscore package implements a family of nonparametric two-sample, and
multi-sample tests for detecting shifts in central tendency (mean) and
spread (variance/dispersion) in gene expression data.
The package includes functionality for negative binomial and zero-inflated
negative binomial models, resampling-based and asymptotic approximations,
and is designed to be robust, flexible and efficient.
}
\section{Main Functions}{

\itemize{
\item \code{\link[=QRscoreTest]{QRscoreTest()}}: Wrapper for one-, two-, and multi-sample QRscore tests.
\item \code{\link[=QRscoreGenetest]{QRscoreGenetest()}}: DE pipeline over many genes.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/songlab-cal/QRscore}
  \item Report bugs at \url{https://github.com/songlab-cal/QRscore/issues}
}

}
\author{
\strong{Maintainer}: Fanding Zhou \email{zhoufd@berkeley.edu} (\href{https://orcid.org/0000-0003-1306-740X}{ORCID})

Authors:
\itemize{
  \item Alan Aw \email{nalawanij@gmail.com} (\href{https://orcid.org/0000-0001-9455-7878}{ORCID})
  \item Dan Erdmann-Pham \email{erdpham@stanford.edu}
  \item Jonathan Fischer \email{jfischer1@ufl.edu} (\href{https://orcid.org/0000-0002-1165-9930}{ORCID})
}

Other contributors:
\itemize{
  \item Xurui Chen \email{xuruichen@berkeley.edu} [contributor]
}

}
\keyword{package}
