% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QFeatures-imputation.R
\docType{data}
\name{impute}
\alias{impute}
\alias{impute,SummarizedExperiment-method}
\alias{impute,QFeatures-method}
\title{Quantitative proteomics data imputation}
\format{
An object of class \code{standardGeneric} of length 1.
}
\usage{
impute

\S4method{impute}{SummarizedExperiment}(object, method, ...)

\S4method{impute}{QFeatures}(object, method, ..., i, name = "imputedAssay")
}
\arguments{
\item{object}{A \code{SummarizedExperiment} or \code{QFeatures} object with
missing values to be imputed.}

\item{method}{\code{character(1)} defining the imputation method. See
\code{imputeMethods()} for available ones. See
\code{\link[MsCoreUtils:imputation]{MsCoreUtils::impute_matrix()}} for details.}

\item{...}{Additional parameters passed to the inner imputation
function. See \code{\link[MsCoreUtils:imputation]{MsCoreUtils::impute_matrix()}} for details.}

\item{i}{A \code{logical(1)} or a \code{character(1)} that defines which
element of the \code{QFeatures} instance to impute. It cannot be
missing and must be of length one.}

\item{name}{A \code{character(1)} naming the new assay name. Default
is \code{imputedAssay}.}
}
\description{
The \code{impute} method performs data imputation on \code{QFeatures} and
\code{SummarizedExperiment} instance using a variety of methods.

Users should proceed with care when imputing data and take
precautions to assure that the imputation produce valid results,
in particular with naive imputations such as replacing missing
values with 0.

See \code{\link[MsCoreUtils:imputation]{MsCoreUtils::impute_matrix()}} for details on
the different imputation methods available and strategies.
}
\examples{
MsCoreUtils::imputeMethods()

data(se_na2)
## table of missing values along the rows (proteins)
table(rowData(se_na2)$nNA)
## table of missing values along the columns (samples)
colData(se_na2)$nNA

## non-random missing values
notna <- which(!rowData(se_na2)$randna)
length(notna)
notna

impute(se_na2, method = "min")

if (require("imputeLCMD")) {
  impute(se_na2, method = "QRILC")
  impute(se_na2, method = "MinDet")
}

if (require("norm"))
  impute(se_na2, method = "MLE")

impute(se_na2, method = "mixed",
       randna = rowData(se_na2)$randna,
       mar = "knn", mnar = "QRILC")

## neighbour averaging
x <- se_na2[1:4, 1:6]
assay(x)[1, 1] <- NA ## min value
assay(x)[2, 3] <- NA ## average
assay(x)[3, 1:2] <- NA ## min value and average
## 4th row: no imputation
assay(x)

assay(impute(x, "nbavg"))
}
\keyword{datasets}
