% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{display}
\alias{display}
\title{Interactive MultiAssayExperiment Explorer}
\usage{
display(object, n = 100, ...)
}
\arguments{
\item{object}{An instance inheriting from \code{MultiAssayExperiment}.}

\item{n}{A \code{numeric(1)} indicating the maximum number of features
(rows) to consider before disabling row clustering and
displaying feature names for speed purposes. Default is 100.}

\item{...}{Additional parameters (other than \code{Rowv} and \code{labRow},
which are set internally based on the value of \code{n}) passed to
heatmap.}
}
\value{
Used for its side effect.
}
\description{
A shiny app to browser and explore the assays in an
\code{MultiAssayExperiment} object. Each assay can be selected from the
dropdown meny in the side panel, and the quantitative data and row
metadata are displayed in the respective \emph{Assay} and \emph{Row data}
tabs. The \emph{Heatmap} tab displays a heatmap of the assay. The
selection of rows in the \emph{Row data} table is used to subset the
features displayed in the \emph{Assay} table and the heatmap to those
currectly selected. See \link{QFeatures} for an example.
}
\examples{
\dontrun{
data(feat2)
display(feat2)
}
}
\author{
Laurent Gatto
}
