% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QFeatures-functions.R
\name{createPrecursorId}
\alias{createPrecursorId}
\title{Create precursor identfiers}
\usage{
createPrecursorId(
  object,
  name = "Precursor.Id",
  fcols = c("Modified.Sequence", "Precursor.Charge"),
  i = seq_along(object)
)
}
\arguments{
\item{object}{An instance of class \code{QFeatures}.}

\item{name}{\code{character(1)} with the name of the new rowData
variable. Default in \code{"Precursor.Id"}.}

\item{fcols}{\code{character()} with the rowData variables names that need to be
\code{\link[=paste0]{paste0()}}ed together to create the new \code{name} variable. Default is
\code{c("Modified.Sequence", "Precursor.Charge")}. Note that these must be
present in \emph{all} assays.}

\item{i}{The assays of \code{object} whose rowData need to be updated. By
default, all assays are considered.}
}
\value{
An updated \code{QFeatures} instance.
}
\description{
The \code{\link[=createPrecursorId]{createPrecursorId()}} is used to create new precursor identifier columns
in a \code{QFeatures} object's assays (more precisely in their rowData). The new
variable is called by default \code{"Precursor.Id"}, and is generated by the
concatenation of other rowData variables that, together, should create
unique identifiers.

These precursor identifiers, assuming their are unique, can then be used to
join assays using \code{\link[=joinAssays]{joinAssays()}}, rather than using the rownames, as
illustrated below.
}
\examples{

## Let use PSM assay of feat3, that don't have any precursor identifiers
data(feat4)
feat4
rowDataNames(feat4)

## Create precursor identifiers by concatenating the charge and the
## sequencing
feat4 <- createPrecursorId(feat4,
                           name = "Precursor.Id",
                           fcols = c("charge", "Sequence"))
rowDataNames(feat4)
rowData(feat4[[1]])[, c("Sequence", "charge", "Precursor.Id")]

## As can be seen below, some precursors are duplicated, which will be
## problematic when joining the assays. Should we join `1SYGFNAAR` in the
## second assay with the first or the second `1SYGFNAAR` in the first assay?
rowData(feat4[[1]])[, "Precursor.Id", drop = FALSE]
rowData(feat4[[2]])[, "Precursor.Id", drop = FALSE]

## Here, one can either aggregate PSMs into PSMs with unique identifers (see
## ?aggregateFeatures) or remove duplicated entries.
nrows(feat4) ## before filtering
feat4 <- filterFeatures(feat4, ~ !isDuplicated(Precursor.Id))
nrows(feat4) ## after filtering

## The assays can now be joined, using the newly created identifier rather
## than the (default) rownames.
feat4 <- joinAssays(feat4, i = 1:2,
                    name = "Precursors",
                    fcol = "Precursor.Id")
feat4
}
\author{
Laurent Gatto
}
