% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QFeatures-missing-data.R
\name{missing-data}
\alias{missing-data}
\alias{zeroIsNA}
\alias{zeroIsNA,SummarizedExperiment,missing-method}
\alias{zeroIsNA,QFeatures,missing-method}
\alias{zeroIsNA,QFeatures,numeric-method}
\alias{zeroIsNA,QFeatures,integer-method}
\alias{zeroIsNA,QFeatures,character-method}
\alias{infIsNA}
\alias{infIsNA,SummarizedExperiment,missing-method}
\alias{infIsNA,QFeatures,missing-method}
\alias{infIsNA,QFeatures,numeric-method}
\alias{infIsNA,QFeatures,integer-method}
\alias{infIsNA,QFeatures,character-method}
\alias{nNA}
\alias{nNA,SummarizedExperiment,missing-method}
\alias{nNA,QFeatures,missing-method}
\alias{nNA,QFeatures,numeric-method}
\alias{nNA,QFeatures,integer-method}
\alias{nNA,QFeatures,character-method}
\alias{filterNA}
\alias{filterNA,SummarizedExperiment-method}
\alias{filterNA,QFeatures-method}
\title{Managing missing data}
\usage{
\S4method{zeroIsNA}{SummarizedExperiment,missing}(object, i)

\S4method{zeroIsNA}{QFeatures,integer}(object, i)

\S4method{zeroIsNA}{QFeatures,numeric}(object, i)

\S4method{zeroIsNA}{QFeatures,character}(object, i)

\S4method{infIsNA}{SummarizedExperiment,missing}(object, i)

\S4method{infIsNA}{QFeatures,integer}(object, i)

\S4method{infIsNA}{QFeatures,numeric}(object, i)

\S4method{infIsNA}{QFeatures,character}(object, i)

\S4method{nNA}{SummarizedExperiment,missing}(object, i)

\S4method{nNA}{QFeatures,integer}(object, i)

\S4method{nNA}{QFeatures,numeric}(object, i)

\S4method{nNA}{QFeatures,character}(object, i)

\S4method{filterNA}{SummarizedExperiment}(object, pNA = 0)

\S4method{filterNA}{QFeatures}(object, pNA = 0, i)
}
\arguments{
\item{object}{An object of class \code{QFeatures} or \code{SummarizedExperiment}.}

\item{i}{One or more indices or names of the assay(s) to be processed.}

\item{pNA}{\code{numeric(1)} providing the maximum proportion of
missing values per feature (row) that is acceptable. Feature
with higher proportions are removed. If 0 (default), features
that contain any number of \code{NA} values are dropped.}
}
\value{
An instance of the same class as \code{object}.
}
\description{
This manual page describes the handling of missing values in
\link{QFeatures} objects. In the following functions, if \code{object} is of
class \code{QFeatures}, an optional assay index or name \code{i} can be
specified to define the assay (by name of index) on which to
operate.

The following functions are currently available:
\itemize{
\item \code{zeroIsNA(object, i)} replaces all 0 in \code{object} by \code{NA}. This
is often necessary when third-party software assume that
features that weren't quantified should be assigned an
intensity of 0.
\item \code{infIsNA(object, i)} replaces all infinite values in \code{object} by
\code{NA}. This is necessary when third-party software divide
expression data by zero values, for instance during custom
normalization.
\item \code{nNA(object, i)} returns a list of missing value summaries. The
first element \code{nNA} gives a \code{DataFrame} with the number and the
proportion of missing values for the whole assay; the second
element \code{nNArows} provides a \code{DataFrame} with the number and the
proportion of missing values for the features (rows) of the
assay(s); the third element \code{nNAcols} provides the number and
the proportions of missing values in each sample of the
assay(s).  When \code{object} has class \code{QFeatures} and additional
column with the assays is provided in each element's
\code{DataFrame}.
\item \code{filterNA(object, pNA, i)} removes features (rows) that contain
a proportion of more missing values of \code{pNA} or higher.
}

See the \emph{Processing} vignette for examples.
}
\examples{
data(ft_na)

## Summary if missing values
nNA(ft_na, 1)

## Remove rows with missing values
assay(filterNA(ft_na, i = 1))

## Replace NAs by zero and back
ft_na <- impute(ft_na, i = 1, method = "zero")
assay(ft_na)
ft_na <- zeroIsNA(ft_na, 1)
assay(ft_na)
}
\seealso{
The \code{impute()} for \code{QFeautres} instances.
}
