% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoPart_MultiMS.R
\name{plot_volcano_wLab}
\alias{plot_volcano_wLab}
\title{Volcano plot with labels for the differentially expressed proteins}
\usage{
plot_volcano_wLab(FC, PV, ProtID, FC_cutoff = 2, PV_cutoff = 0.05,
  figtitle = "")
}
\arguments{
\item{FC}{vector of fold changes}

\item{PV}{vector of p-values, same lenght as FC}

\item{ProtID}{vector of protein IDs, can be gene IDs, same lenght as FC & PV.
Namaes in this vector will be displayed in the volcano plot
for differentially expressed proteins for this reason short names
are preferred.}

\item{FC_cutoff}{fold change cutoff where to draw vertical cutoff
lines, default = 2}

\item{PV_cutoff}{p-value cutoff where to draw a horisontal cutoff line,
default ==.05}

\item{figtitle}{title to display at the top of the figure, default = ''}
}
\value{
Nil
}
\description{
Function plots fold changes and p-values as a volcano plot.
Two lines are plotted for the p-value cutoff at p = PV_cutoff
(solid line) and p = 0.1 (dashed line).
}
\examples{
data(mm_peptides)
head(mm_peptides)
intsCols = 8:13 # different from parameter names as
                # R uses outer name spaces if variable is undefined
metaCols = 1:7 # reusing this variable
m_logInts = make_intencities(mm_peptides, intsCols)  # will reuse the name
m_prot.info = make_meta(mm_peptides, metaCols)
m_logInts = convert_log2(m_logInts)

# Normalize data
grps = as.factor(c('CG','CG','CG', 'mCG','mCG','mCG'))

set.seed(135)
mm_m_ints_eig1 = eig_norm1(m=m_logInts,treatment=grps,prot.info=m_prot.info)
mm_m_ints_eig1$h.c # check the number of bias trends detected

# Impute missing values
mm_m_ints_norm = eig_norm2(rv=mm_m_ints_eig1)
mm_prot.info = mm_m_ints_norm$normalized[,1:7]
mm_norm_m =  mm_m_ints_norm$normalized[,8:13]

set.seed(125)
imp_mm = MBimpute(mm_norm_m, grps, prot.info=mm_prot.info,
                  pr_ppos=2, my.pi=0.05, compute_pi=FALSE)
DE_res = peptideLevel_DE(imp_mm$y_imputed, grps, imp_mm$imp_prot.info,
                         pr_ppos=2)
plot_volcano_wLab(DE_res$FC, DE_res$BH_P_val, DE_res$ProtID, FC_cutoff=1.5,
                  PV_cutoff=.05, figtitle='Mouse DE')

}
