% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peptideLevel_DE.R
\name{plot_3_pep_trends_NOfile}
\alias{plot_3_pep_trends_NOfile}
\title{Plot peptide trends}
\usage{
plot_3_pep_trends_NOfile(mm, prot.info, sorted_norm_m, sorted_prot.info,
  imp_mm, imp_prot.info, prot_to_plot, prot_to_plot_col, gene_name,
  gene_name_col, mylabs)
}
\arguments{
\item{mm}{matrix of raw intensities}

\item{prot.info}{metadata for the intensities in mm}

\item{sorted_norm_m}{normalized intensities, possibly fewer than in mm due 
to filtering out peptides with fewer than one
observation per treatment group}

\item{sorted_prot.info}{metadata for the intensities in sorted_norm_m}

\item{imp_mm}{imputed intensities (post normalization)}

\item{imp_prot.info}{metadata for the imputed intensities in imp_mm}

\item{prot_to_plot}{protein ID to plot}

\item{prot_to_plot_col}{protein ID column index}

\item{gene_name}{gene ID to plot}

\item{gene_name_col}{gene ID to plot column index}

\item{mylabs}{sample labels to be plotted on x-axis}
}
\value{
Nil
}
\description{
Plot Raw, Normalized and Normalized & Imputed peptide trends for a protein
}
\examples{

data("hs_peptides") # loads variable hs_peptides
intsCols = 8:13 # column indeces that contain intensities
m_logInts = make_intencities(hs_peptides, intsCols)
# replace 0's with NA's as NA's are more appropriate
# for anlysis and log2 transform
m_logInts = convert_log2(m_logInts)
# column indices that contain metadata such as protein IDs and sequences
metaCols = 1:7
m_prot.info = make_meta(hs_peptides, metaCols)
grps = as.factor(c('CG','CG','CG', 'mCG','mCG','mCG'))

set.seed(135)
hs_m_ints_eig1 = eig_norm1(m=m_logInts,treatment=grps,prot.info=m_prot.info)
hs_m_ints_eig1$h.c = 2 # looks like there are 2 bias trends at least
hs_m_ints_norm = eig_norm2(rv=hs_m_ints_eig1)
hs_prot.info = hs_m_ints_norm$normalized[,metaCols]
hs_norm_m =  hs_m_ints_norm$normalized[,intsCols]

set.seed(125)
imp_hs = MBimpute(hs_norm_m, grps, prot.info=hs_prot.info,
                  pr_ppos=3, my.pi=0.05, compute_pi=FALSE)
mylabs = c( 'CG','CG','CG', 'mCG','mCG','mCG')
prot_to_plot = 'Prot32' # 43
gene_to_plot = 'Gene32'
plot_3_pep_trends_NOfile(as.matrix(hs_m_ints_eig1$m),
                         hs_m_ints_eig1$prot.info,
                         as.matrix(hs_norm_m),
                         hs_prot.info,
                         imp_hs$y_imputed,
                         imp_hs$imp_prot.info,
                         prot_to_plot, 3,
                         gene_to_plot, 4, mylabs)

}
