% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoPart_MultiMS.R
\name{get_presAbs_prots}
\alias{get_presAbs_prots}
\title{Get Presence/Absence Proteins}
\usage{
get_presAbs_prots(mm_list, prot.info, protnames_norm, prot_col_name)
}
\arguments{
\item{mm_list}{list of matrices of intensities for each experiment.
Dimentions: numpeptides x numsamples
different for each dataset.}

\item{prot.info}{list of protein and peptide metadata/mappings
for each matrix in mm_list, data.frames "parallel"
to matrices in mm_list.}

\item{protnames_norm}{list of protein pdentifies to be used
to determine peptides that will be placed into
Presence/Absence analysis category due to
too many missing peptides. Taken from the
return value from eig_norm2().}

\item{prot_col_name}{column name (string) that will be used to get
ProteinIDs in the raw data matrices}
}
\value{
list of lists of length 2
\describe{
  \item{intensities}{list of intecities in the same
        order and of the same length as
        the number of datasets that were passed into the function}
  \item{protein metadata}{list of protein metadata in the
        same order and of the same length as
        the number of datasets that as were passed into the function}
}
}
\description{
Function get_presAbs_prots() produces a
subset of protein meta data and intencities
for multiple datasets pass in as a list.
If a single dataset is passed in
(list of length one) it will be processed in the same way as longer lists.
}
\examples{
# Load mouse dataset
data(mm_peptides)
head(mm_peptides)
intsCols = 8:13
metaCols = 1:7 # reusing this variable
m_logInts = make_intencities(mm_peptides, intsCols)  # will reuse the name
m_prot.info = make_meta(mm_peptides, metaCols)
m_logInts = convert_log2(m_logInts)
grps = as.factor(c('CG','CG','CG', 'mCG','mCG','mCG'))
mm_m_ints_eig1 = eig_norm1(m=m_logInts,treatment=grps,prot.info=m_prot.info)
mm_m_ints_eig1$h.c # check the number of bias trends detected
mm_m_ints_norm = eig_norm2(rv=mm_m_ints_eig1)

# Load human dataset
data(hs_peptides)
head(hs_peptides)
intsCols = 8:13
metaCols = 1:7 # reusing this variable
m_logInts = make_intencities(hs_peptides, intsCols)  # will reuse the name
m_prot.info = make_meta(hs_peptides, metaCols)
m_logInts = convert_log2(m_logInts)
grps = as.factor(c('CG','CG','CG', 'mCG','mCG','mCG'))
hs_m_ints_eig1 = eig_norm1(m=m_logInts,treatment=grps,prot.info=m_prot.info)
hs_m_ints_eig1$h.c # check the number of bias trends detected
hs_m_ints_norm = eig_norm2(rv=hs_m_ints_eig1)

# Set up for presence/absence analysis
raw_list = list()
norm_imp_prot.info_list = list()
raw_list[[1]] = mm_m_ints_eig1$m
raw_list[[2]] = hs_m_ints_eig1$m
norm_imp_prot.info_list[[1]] = mm_m_ints_eig1$prot.info
norm_imp_prot.info_list[[2]] = hs_m_ints_eig1$prot.info

protnames_norm_list = list()
protnames_norm_list[[1]] = unique(mm_m_ints_norm$normalized$MatchedID)
protnames_norm_list[[2]] = unique(hs_m_ints_norm$normalized$MatchedID)

presAbs_dd = get_presAbs_prots(mm_list=raw_list,
                              prot.info=norm_imp_prot.info_list,
                              protnames_norm=protnames_norm_list,
                              prot_col_name=2)
}
