% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_manualSequences.R
\name{importTranscriptSequences}
\alias{importTranscriptSequences}
\title{Incorporate manual transcript sequences into the ProteoDiscography}
\usage{
importTranscriptSequences(
  ProteoDiscography,
  transcripts,
  removeExisting = FALSE,
  overwriteDuplicateSamples = FALSE
)
}
\arguments{
\item{ProteoDiscography}{({ProteoDiscography}): ProteoDiscography object which stores the annotation and genomic sequences.}

\item{transcripts}{(\link[S4Vectors]{DataFrame}): DataFrame containing metadata and the transcript sequences.}

\item{removeExisting}{(logical): Should previous mutations within the ProteoDiscography be removed?}

\item{overwriteDuplicateSamples}{(logical): Replace duplicate samples (TRUE) or throw an error if duplicate samples are found.}
}
\value{
{ProteoDiscography} with added mutant transcript sequences from manual input.
}
\description{
The given DataFrame (transcripts) should include the following columns:
\itemize{
 \item{sample: Names of the samples. (character)}
 \item{identifier: The identifier which will be used in downstream analysis. (character)}
 \item{Tx.SequenceMut: The mutant mRNA sequence. (DNAStringSet)}
 \item{gene: Name of the gene. (character, optional)}
} 

The supplied mutant sequences do not need to have a respective record within the used TxDb as these are handled as independent sequences.
}
\examples{

 ProteoDiscography.hg19 <- ProteoDisco::generateProteoDiscography(
   TxDb = TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene, 
   genomeSeqs = BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19
 )
 
 manualSeq <- S4Vectors::DataFrame(
   sample = rep('Example', 2),
   identifier = c('Example 1', 'Example 2'),
   gene = c('GeneA', 'GeneB'),
   Tx.SequenceMut = Biostrings::DNAStringSet(list(Biostrings::DNAString('ATCGGGCCCGACGTT'), Biostrings::DNAString('GCTAGCGATCAGGGA')))
 )

 # Add to ProteoDiscography.
 ProteoDiscography.hg19 <- ProteoDisco::importTranscriptSequences(
   ProteoDiscography.hg19, 
   transcripts = manualSeq
 )

}
\author{
Job van Riet \email{j.vanriet@erasmusmc.nl}

Wesley van de Geer \email{w.vandegeer@erasmusmc.nl}
}
\concept{methods}
\keyword{methods}
