% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protgenerics.R
\name{processingQueue}
\alias{processingQueue}
\alias{processingChunkSize}
\alias{processingChunkSize<-}
\alias{addProcessing}
\alias{applyProcessing}
\alias{processingChunkFactor}
\title{Processing Queue}
\usage{
processingChunkSize(object, ...)

processingChunkSize(object, ...) <- value

addProcessing(object, ...)

applyProcessing(object, ...)

processingChunkFactor(object, ...)
}
\arguments{
\item{object}{The object with the processing queue.}

\item{...}{Additional parameters to be defined.}

\item{value}{The replacement value.}
}
\description{
These methods are related to the *processing queue* implemented in the
[Spectra](https://github.com/RforMassSpectrometry/Spectra) and
[Chromatograms](https://github.com/RforMassSpectrometry/Chromatograms)
packages.

- `addProcessing()` adds a processing step to the processing queue.

- `applyProcessing()` execute the processing queue replacing the original
  data in `object` with the processed one.

- `processingChunkSize()` and `processingChunkSize()<-` are supposed to get
  and set the number of elements (e.g. spectra) for which the data is loaded
  into memory and processed at a time.

- `processingChunkFactor()`: defines a `factor` that can be used to split
  `object` into chunks defined by the length of `object` and its
  `processingChunkSize()`.
}
