% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_initial_conditions.R
\name{make_initial_conditions}
\alias{make_initial_conditions}
\title{Make initial conditions for curve fitting with a mixture of Gaussians}
\usage{
make_initial_conditions(
  chromatogram,
  n_gaussians,
  method = c("guess", "random"),
  sigma_default = 2,
  sigma_noise = 0.5,
  mu_noise = 1.5,
  A_noise = 0.5
)
}
\arguments{
\item{chromatogram}{a numeric vector corresponding to the chromatogram trace}

\item{n_gaussians}{the number of Gaussians being fit}

\item{method}{one of "guess" or "random", discussed above}

\item{sigma_default}{the default mean initial value of sigma}

\item{sigma_noise}{the amount of random noise to add or subtract from 
the default mean initial value of sigma}

\item{mu_noise}{the amount of random noise to add or subtract from the 
Gaussian centers in "guess" mode}

\item{A_noise}{the amount of random noise to add or subtract from the 
Gaussian heights in "guess" mode}
}
\value{
a list of three numeric vectors (A, mu, and sigma), each having
a length equal to the maximum number of Gaussians to fit
}
\description{
Construct a set of initial conditions for curve fitting using nonlinear
least squares using a mixture of Gaussians. The "guess" method ports 
code from the Matlab release of PrInCE. This method finds local maxima 
within the chromatogram, orders them by their separation (in number of 
fractions) from the previous local maxima, and uses the positions and heights
of these local maxima (+/- some random noise) as initial conditions for 
Gaussian curve-fitting. The "random" method simply picks random values 
within the fraction and intensity intervals as starting points for Gaussian
curve-fitting. The initial value of sigma is set by default to a random 
number within +/- 0.5 of two for both modes; this is based on our manual 
inspection of a large number of chromatograms.
}
\examples{
data(scott)
chrom <- clean_profile(scott[16, ])
set.seed(0)
start <- make_initial_conditions(chrom, n_gaussians = 2, method = "guess")

}
