% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_complexes.R
\name{detect_complexes}
\alias{detect_complexes}
\title{Detect significantly interacting complexes in a chromatogram matrix}
\usage{
detect_complexes(
  profile_matrix,
  complexes,
  method = c("pearson", "euclidean"),
  min_pairs = 10,
  bootstraps = 100,
  progress = TRUE
)
}
\arguments{
\item{profile_matrix}{a matrix of chromatograms, with proteins in the rows
and fractions in the columns, or a \code{\linkS4class{MSnSet}} object}

\item{complexes}{a named list of protein complexes, where the name is the
complex name and the entries are proteins within that complex}

\item{method}{method to use to calculate edge weights;
one of \code{pearson} or \code{euclidean}}

\item{min_pairs}{the minimum number of pairwise observations to count a 
correlation or distance towards the z score}

\item{bootstraps}{number of bootstraps to execute to estimate z scores}

\item{progress}{whether to show the progress of the function}
}
\value{
a named vector of z scores for each complex in the input list
}
\description{
Use a permutation testing approach to identify complexes that show a 
significant tendency to interact, relative to random sets of complexes
of equivalent size. The function begins by calculating the Pearson 
correlation or Euclidean distance between all proteins in the matrix, and
}
\examples{
data(scott)
data(gold_standard)
complexes <- gold_standard[lengths(gold_standard) >= 3]
z_scores <- detect_complexes(t(scott), complexes)
length(na.omit(z_scores)) ## number of complexes that could be tested
z_scores[which.max(z_scores)] ## most significant complex

}
