% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_profiles.R
\name{clean_profiles}
\alias{clean_profiles}
\title{Preprocess a co-elution profile matrix}
\usage{
clean_profiles(
  profile_matrix,
  impute_NA = TRUE,
  smooth = TRUE,
  smooth_width = 4,
  noise_floor = 0.001
)
}
\arguments{
\item{profile_matrix}{a numeric matrix of co-elution profiles, with proteins
in rows, or a \code{\linkS4class{MSnSet}} object}

\item{impute_NA}{if true, impute single missing values with the average of
neighboring values}

\item{smooth}{if true, smooth the chromatogram with a moving average filter}

\item{smooth_width}{width of the moving average filter, in fractions}

\item{noise_floor}{mean value of the near-zero noise to add}
}
\value{
a cleaned matrix
}
\description{
Clean a matrix of co-elution/co-fractionation profiles by 
(1) imputing single missing
values with the average of neighboring values, (2) replacing missing values
with random, near-zero noise, and (3) smoothing with a moving average
filter.
}
\examples{
data(scott)
mat <- scott[c(1, 16), ]
mat_clean <- clean_profiles(mat)

}
