% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choose_gaussians.R
\name{choose_gaussians}
\alias{choose_gaussians}
\title{Fit a Gaussian mixture model to a co-elution profile}
\usage{
choose_gaussians(
  chromatogram,
  points = NULL,
  max_gaussians = 5,
  criterion = c("AICc", "AIC", "BIC"),
  max_iterations = 10,
  min_R_squared = 0.5,
  method = c("guess", "random"),
  filter_gaussians_center = TRUE,
  filter_gaussians_height = 0.15,
  filter_gaussians_variance_min = 0.1,
  filter_gaussians_variance_max = 50
)
}
\arguments{
\item{chromatogram}{a numeric vector corresponding to the chromatogram trace}

\item{points}{optional, the number of non-NA points in the raw data}

\item{max_gaussians}{the maximum number of Gaussians to fit; defaults to 5.
Note that Gaussian mixtures with more parameters than observed (i.e., 
non-zero or NA) points will not be fit.}

\item{criterion}{the criterion to use for model selection;
one of "AICc" (corrected AIC, and default), "AIC", or "BIC"}

\item{max_iterations}{the number of times to try fitting the curve with
different initial conditions; defaults to 10}

\item{min_R_squared}{the minimum R-squared value to accept when fitting the
curve with different initial conditions; defaults to 0.5}

\item{method}{the method used to select the initial conditions for
nonlinear least squares optimization (one of "guess" or "random"); 
see \code{\link{make_initial_conditions}} for details}

\item{filter_gaussians_center}{true or false: filter Gaussians whose centres
fall outside the bounds of the chromatogram}

\item{filter_gaussians_height}{Gaussians whose heights are below this 
fraction of the chromatogram height will be filtered. Setting this value to
zero disables height-based filtering of fit Gaussians}

\item{filter_gaussians_variance_min}{Gaussians whose variance is below this 
threshold will be filtered. Setting this value to zero disables filtering.}

\item{filter_gaussians_variance_max}{Gaussians whose variance is above this 
threshold will be filtered. Setting this value to zero disables filtering.}
}
\value{
a list with five entries: the number of Gaussians used to fit
the curve; the R^2 of the fit; the number of iterations used to 
fit the curve with different initial conditions; the coefficients of the 
fit model; and the curve predicted by the fit model.
}
\description{
Fit mixtures of one or more Gaussians to the curve formed by a chromatogram
profile, and choose the best fitting model using an information criterion
of choice.
}
\examples{
data(scott)
chrom <- clean_profile(scott[1, ])
gauss <- choose_gaussians(chrom, max_gaussians = 3)

}
