% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_gaussians.R
\name{check_gaussians}
\alias{check_gaussians}
\title{Check the format of a list of Gaussians}
\usage{
check_gaussians(
  gaussians,
  proteins = NULL,
  replicate_idx = NULL,
  n_error = 3,
  pct_warning = 0.1
)
}
\arguments{
\item{gaussians}{the list of Gaussians}

\item{proteins}{the complete set of input proteins}

\item{replicate_idx}{the replicate being analyzed, if input proteins are 
provided; used to throw more informative error messages}

\item{n_error}{minimum number of proteins that can have fitted Gaussians
without throwing an error}

\item{pct_warning}{minimum fraction of proteins that can have fitted
Gaussians without giving a warning}
}
\value{
\code{TRUE} if all conditions are met, but throws an error if any 
  is not
}
\description{
Test whether an input list of Gaussians conforms to the format expected
by PrInCE: that is, a named list with five fields for each entry, i.e., the
number of Gaussians in the mixture model, the {\eqn{r^2}} value, the 
number of iterations used by \code{\link[stats]{nls}}, the coefficients of
each model, and the fitted curve.
}
\details{
Optionally, some extra checks will be 
done on the fraction of proteins in the complete dataset for which a 
Gaussian mixture model could be fit, if provided. In particular, the function
will throw an error if fewer than \code{n_error} proteins have a fitted 
Gaussian, and emit a warning if fewer than \code{pct_warning} do.
}
\examples{
data(scott_gaussians)
check_gaussians(scott_gaussians)

}
