% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_precision.R
\name{calculate_precision}
\alias{calculate_precision}
\title{Calculate precision at each point in a sequence}
\usage{
calculate_precision(labels)
}
\arguments{
\item{labels}{a vector of zeroes (FPs) and ones (TPs)}
}
\value{
a vector of the same length giving the precision at each point in the
input vector
}
\description{
Calculate the precision of a list of interactions at each point in the list,
given a set of labels.
}
\examples{
## calculate features
data(scott)
data(scott_gaussians)
subset <- scott[seq_len(500), ] ## limit to first 500 proteins
gauss <- scott_gaussians[names(scott_gaussians) \%in\% rownames(subset)]
features <- calculate_features(subset, gauss)
## make training labels
data(gold_standard)
ref <- adjacency_matrix_from_list(gold_standard)
labels <- make_labels(ref, features)
## predict interactions with naive Bayes classifier
ppi <- predict_ensemble(features, labels, classifier = "NB", cv_folds = 3, 
                        models = 1)
## tag precision of each interaction
ppi$precision <- calculate_precision(ppi$label)

}
