% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{mstep_mu}
\alias{mstep_mu}
\title{Internal Function 8}
\usage{
mstep_mu(
  zi,
  g_clusternum,
  dim_data,
  cluster_num,
  weights,
  muh,
  covh,
  mg,
  mug,
  neg_assum,
  lambdas,
  coefs
)
}
\arguments{
\item{zi}{the expected log-likelihood found on the E step}

\item{g_clusternum}{cluster labels from base clustering}

\item{dim_data}{the dimension of the dataset}

\item{cluster_num}{The expected maximum number of clusters}

\item{weights}{combinations of coefficients of the cluster centers}

\item{muh}{the matrix of cluster centers at level l}

\item{covh}{the covariance matrix of clusters at level l}

\item{mg}{cluster sizes of base clustering result}

\item{mug}{the matrix of cluster centers at level l+1}

\item{neg_assum}{the estimated cluster center of negative population}

\item{lambdas}{The penalty terms for the deviation from the expected cluster centers. Higher \code{lambdas} penalizes the deviation more.}

\item{coefs}{The coefficients to adjust for the expected cluster centers. The default is 1 which can be used for common assay designs and has
to be modified for special assays such as competing assays.}
}
\value{
muh the cluster centers at level l in the EM algorithm
}
\description{
This function calculates mu in M-step of EM algorithm
}
\keyword{internal}
