% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatTestUnpaired.R
\name{rp_unpaired}
\alias{rp_unpaired}
\title{Perform unpaired rank products test}
\usage{
rp_unpaired(tData, trefData)
}
\arguments{
\item{tData}{The data matrix for the test group (features are rows).}

\item{trefData}{The data matrix for the reference group (features are rows).}
}
\value{
A list containing the p-values and q-values.
}
\description{
Perform unpaired rank products test
}
\details{
This function calculates the p-values and q-values using rankd product
statistics. The function requires having the same number of samples per
group. The function uses parallel computing to speed up the calculations.
}
\examples{
tData <- matrix(rnorm(1000), nrow = 100)
trefData <- matrix(rnorm(1000), nrow = 100)
rp_unpaired(tData, trefData)

}
