% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatTestPaired.R
\name{limma_paired}
\alias{limma_paired}
\title{Perform paired limma analysis}
\usage{
limma_paired(MAData, NumCond, NumReps)
}
\arguments{
\item{MAData}{A ratio matrix of gene expression data. The rows are genes and
the columns are samples.
Replicates must be grouped together.}

\item{NumCond}{The number of ratios to check vs zero level}

\item{NumReps}{The number of replicates per condition.}
}
\value{
A list containing the p-values and q-values.
}
\description{
This function performs paired limma analysis on MAData.
}
\examples{
MAData <- matrix(rnorm(600), nrow = 100)
NumCond <- 3
NumReps <- 2
limma_res <- limma_paired(MAData, NumCond, NumReps)
head(limma_res$qlvalues)

}
\keyword{analysis}
\keyword{limma}
\keyword{paired}
