% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFuncs.R
\name{check_stat_names}
\alias{check_stat_names}
\title{Check Statistical Test and Comparison Names}
\usage{
check_stat_names(fulldata, compNames, testNames)
}
\arguments{
\item{fulldata}{A \code{SummarizedExperiment} object containing the dataset
and metadata for statistical analyses.}

\item{compNames}{A character vector of comparison names to be verified
against the \code{SummarizedExperiment} metadata. If set to "all",
the function checks for the presence of any comparison names in the metadata.}

\item{testNames}{A character vector of statistical test names to be verified
against the \code{SummarizedExperiment} metadata.}
}
\value{
The function return the updated comparison names if the checks pass.
}
\description{
Verifies if the provided test names and comparison names are correct
and have been executed within the given \code{SummarizedExperiment} object.
It checks for the presence of specific metadata related to the tests
and comparisons to ensure that the requested analyses have been carried out.
}
\details{
This function is used to ensure that the requested statistical tests
and comparisons have been correctly named and executed prior to further
analysis. It verifies that the names provided match those stored within the
metadata of the \code{SummarizedExperiment} object. If the names do not match or
the necessary metadata is missing, the function stops execution and returns
an error message indicating the issue.
}
\examples{
data(liver_example)
compNames <- "all"
testNames <- c("limma", "t_test")
check_stat_names(liver_example, compNames, testNames)

}
