% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importAmplitudeData.R
\name{importAmplitudeData}
\alias{importAmplitudeData}
\title{importAmplitudeData}
\usage{
importAmplitudeData(
  dataDirectory,
  skipLines = c(0, 4),
  nrChannels = c(1, 2)[2],
  targetChannel = c(1, 2, 3, 4, 5, 6)[1],
  controlChannel = c(1, 2, 3, 4, 5, 6)[2]
)
}
\arguments{
\item{dataDirectory}{Path to directory containing Quantasoft amplitude files
from one 96 well plate. Since well coordinates are used as identifiers,
files in this directory should all be from the same 96 well plate.
Furthermore, there should be no other files than the amplitude files from
a well plate in the directory.}

\item{skipLines}{Number of lines to skip in amplitude data files. Must be 0
or 4 depending on software used to export data. 0 for QuantaSoft, 4 for
QXmanager.}

\item{nrChannels}{Number of channels/dyes used. Default nrChannels=2}

\item{targetChannel}{The channel nr used as target channel (default=1)}

\item{controlChannel}{The channel nr used as control channel (default=2)}
}
\value{
The function returns a list of dataframes named with the well ID
    and contains the amplitude values from the corresponding well.
}
\description{
importAmplitudeData
}
\examples{
# Path to example data files included in PoDCall
path <- system.file("extdata", "Amplitudes/", package="PoDCall")

# Read in data files
dataList <- importAmplitudeData(dataDirectory=path, skipLines=0)

}
