% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTaxaGroups.R
\name{varDistTaxPlot}
\alias{varDistTaxPlot}
\title{Create variable distribution comparison plot}
\usage{
varDistTaxPlot(data, plotParameters)
}
\arguments{
\item{data}{dataframe for plotting. Last column
indicates what type of taxon group (in- or out-group). The first (or first 2)
column contains values of the variables. See ?dataVarDistTaxGroup}

\item{plotParameters}{plot parameters, including size of x-axis, y-axis,
legend and title; position of legend ("right", "bottom" or "none");
mean/median point; names of in-group and out-group; and plot title.
NOTE: Leave blank or NULL to use default values.}
}
\value{
Distribution plots as a grob (gtable) object. Use grid.draw to plot.
}
\description{
Create variable distribution plots between 2 groups of taxa for
a selected gene.
}
\examples{
data("mainLongRaw", package="PhyloProfile")
data <- mainLongRaw
inGroup <- c("ncbi9606", "ncbi10116")
variable <- colnames(data)[c(4, 5)]
plotDf <- dataVarDistTaxGroup(data, inGroup, "101621at6656", variable)
plotParameters <- list(
    "xSize" = 12,
    "ySize" = 12,
    "titleSize" = 15,
    "legendSize" = 12,
    "legendPosition" = "right",
    "mValue" = "mean",
    "inGroupName" = "In-group",
    "outGroupName" = "Out-group",
    "title" = "101621at6656"
)
g <- varDistTaxPlot(plotDf, plotParameters)
grid::grid.draw(g)
}
\seealso{
\code{\link{dataVarDistTaxGroup}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
