% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umapClustering.R
\name{prepareDimRedData}
\alias{prepareDimRedData}
\title{Prepare data for dimension reduction}
\usage{
prepareDimRedData(longDf = NULL, taxonRank = NULL, type = "taxa",
    taxDB = NULL, filterVar = "both", cutoff = 0, groupLabelsBy = "taxa")
}
\arguments{
\item{longDf}{input phyloprofile file in long format}

\item{taxonRank}{taxonomy rank for labels (e.g. "phylum")}

\item{type}{type of clustering, either "taxa" (default) or "genes"}

\item{taxDB}{path to taxonomy database}

\item{filterVar}{choose variable (either "var1", "var2" or "both") to filter
the data. Default: "both"}

\item{cutoff}{cutoff to filter data values. Default: 0}

\item{groupLabelsBy}{group labels by the number of "taxa" (default) or
"genes"}
}
\value{
A dataframe in wide format
}
\description{
Prepare data for dimension reduction
}
\examples{
rawInput <- system.file(
   "extdata", "test.main.long", package = "PhyloProfile", mustWork = TRUE
)
longDf <- createLongMatrix(rawInput)
prepareDimRedData(longDf, "phylum")
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
