% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDomainPlot.R
\name{modifyFeatureName}
\alias{modifyFeatureName}
\title{Modify feature names}
\usage{
modifyFeatureName(domainDf = NULL)
}
\arguments{
\item{domainDf}{domain data as a dataframe object}
}
\value{
Dataframe contains simlified domain names in yLabel column
}
\description{
Simplify feature names (e.g. TM for transmembrane domain,
LCR for low complexity regions, remove tool names from domain name) and add
weight to feature names (if available)
}
\examples{
domainFile <- system.file(
    "extdata", "domainFiles/101621at6656.domains",
    package = "PhyloProfile", mustWork = TRUE
)
seedID <- "101621at6656"
domainDf <- parseDomainInput(seedID, domainFile, "file")
PhyloProfile:::modifyFeatureName(domainDf)
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
