% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createProfilePlot.R
\name{highlightProfilePlot}
\alias{highlightProfilePlot}
\title{Highlight gene and/or taxon of interest on the phylogenetic profile plot}
\usage{
highlightProfilePlot(profilePlot = NULL, plotDf = NULL,
    taxonHighlight = "none", workingRank = "none", geneHighlight = NULL,
    taxDB = NULL, xAxis = "taxa")
}
\arguments{
\item{profilePlot}{initial (highlighted) profile plot}

\item{plotDf}{dataframe for plotting the heatmap phylogentic profile}

\item{taxonHighlight}{taxon of interst. Default = "none".}

\item{workingRank}{working taxonomy rank (needed only for highlight taxon).}

\item{geneHighlight}{gene of interest. Default = NULL.}

\item{taxDB}{Path to the taxonomy DB files}

\item{xAxis}{type of x-axis (either "genes" or "taxa")}
}
\value{
A profile heatmap plot with highlighted gene and/or taxon of interest
as ggplot object.
}
\description{
Highlight gene and/or taxon of interest on the phylogenetic profile plot
}
\examples{
data("finalProcessedProfile", package="PhyloProfile")
plotDf <- dataMainPlot(finalProcessedProfile)
plotParameter <- list(
    "xAxis" = "taxa",
    "geneIdType" = "geneID",
    "var1ID" = "FAS_FW",
    "var2ID"  = "FAS_BW",
    "midVar1" = 0.5,
    "midColorVar1" =  "#FFFFFF",
    "lowColorVar1" =  "#FF8C00",
    "highColorVar1" = "#4682B4",
    "midVar2" = 1,
    "midColorVar2" =  "#FFFFFF",
    "lowColorVar2" = "#CB4C4E",
    "highColorVar2" = "#3E436F",
    "paraColor" = "#07D000",
    "xSize" = 8,
    "ySize" = 8,
    "legendSize" = 8,
    "mainLegend" = "top",
    "dotZoom" = 0,
    "xAngle" = 60,
    "guideline" = 0,
    "colorByGroup" = FALSE,
    "colorByOrthoID" = FALSE
)
profilePlot <- heatmapPlotting(plotDf, plotParameter)
taxonHighlight <- "none"
workingRank <- "class"
geneHighlight <- "100265at6656"
highlightProfilePlot(
    profilePlot, plotDf, taxonHighlight, workingRank, geneHighlight,
    NULL, plotParameter$xAxis
)
}
\seealso{
\code{\link{dataMainPlot}}, \code{\link{dataCustomizedPlot}},
\code{\link{heatmapPlotting}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
