% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterProfile.R
\name{getDataClustering}
\alias{getDataClustering}
\title{Get data for calculating distance matrix from phylogenetic profiles}
\usage{
getDataClustering(data, profileType = "binary", var1AggBy = "max",
    var2AggBy = "max")
}
\arguments{
\item{data}{a data frame contains processed and filtered profiles (see
?fullProcessedProfile and ?filterProfileData, ?fromInputToProfile)}

\item{profileType}{type of data used for calculating the distance matrix.
Either "binary" (consider only the presence/absence status of orthlogs),
"orthoID" (consider ortholog IDs as values for clustering),
"var1"/"var2" for taking values of the additional variables into account.
Default = "binary".}

\item{var1AggBy}{aggregate method for VAR1 (min, max, mean or median).
Default = "max".}

\item{var2AggBy}{aggregate method for VAR2 (min, max, mean or median).
Default = "max".}
}
\value{
A wide dataframe contains values for calculating distance matrix.
}
\description{
Get data for calculating distance matrix from phylogenetic profiles
}
\examples{
data("finalProcessedProfile", package="PhyloProfile")
data <- finalProcessedProfile
profileType <- "binary"
var1AggregateBy <- "max"
var2AggregateBy <- "mean"
getDataClustering(data, profileType, var1AggregateBy, var2AggregateBy)
}
\seealso{
\code{\link{fromInputToProfile}}
}
\author{
Carla Mölbert (carla.moelbert@gmx.de), Vinh Tran
(tran@bio.uni-frankfurt.de)
}
