% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeDistribution.R
\name{createVariableDistributionData}
\alias{createVariableDistributionData}
\title{Create data for additional variable distribution}
\usage{
createVariableDistributionData(inputData, var1Cutoff = c(0 ,1),
    var2Cutoff = c(0, 1))
}
\arguments{
\item{inputData}{dataframe contains raw input data in long format
(see ?mainLongRaw)}

\item{var1Cutoff}{min and max cutoff for var1. Default = c(0, 1).}

\item{var2Cutoff}{min and max cutoff for var2. Default = c(0, 1).}
}
\value{
A dataframe for analysing the distribution of the additional
variable(s) containing the protein (ortholog) IDs and the values of their
variables (var1 and var2).
}
\description{
Create data for additional variable distribution
}
\examples{
data("mainLongRaw", package="PhyloProfile")
createVariableDistributionData(
    mainLongRaw, c(0, 1), c(0.5, 1)
)
}
\seealso{
\code{\link{mainLongRaw}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
